<?php

declare(strict_types=1);

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserHasRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string  ...$roles
     */
    public function handle(Request $request, Closure $next, string ...$roles): Response
    {
        if (!$request->user()) {
            return response()->json([
                'message' => 'Unauthenticated.',
            ], Response::HTTP_UNAUTHORIZED);
        }

        // Admin can bypass role restrictions
        if ($request->user()->isAdmin()) {
            return $next($request);
        }

        if (!in_array($request->user()->role, $roles, true)) {
            return response()->json([
                'message' => 'Forbidden. Insufficient permissions.',
            ], Response::HTTP_FORBIDDEN);
        }

        return $next($request);
    }
}
